local sBannerPath = THEME:GetPathG("Common", "fallback banner");
local sJacketPath = THEME:GetPathG("Common", "fallback jacket");
local bAllowJackets = true

local t = Def.ActorFrame {
	Def.Sprite {
		Name="Banner";
		InitCommand=cmd(scaletoclipped,160,160;);
		-- Commands to make sure each banenr gets the right look.
		BannerCommand=cmd(scaletoclipped,160,160);
		JacketCommand=cmd(scaletoclipped,160,160);
		-- Set em up the graphics.
		SetMessageCommand=function(self,params)
			local Song = params.Song;
			local Course = params.Course;
			-- We have a song, not course
			if Song then
				-- Have Jacket
				if ( Song:GetJacketPath() ~=  nil ) and ( bAllowJackets ) then
					self:Load( Song:GetJacketPath() );
					self:playcommand("Jacket");
				-- Use Background if we want Jackets
				elseif ( Song:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Song:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- Use Banner if we dont care 
				elseif ( Song:GetBannerPath() ~= nil ) then
					self:Load( Song:GetBannerPath() );
					self:playcommand("Banner");
				-- Use Default
				else
				  self:Load( bAllowJackets and sBannerPath or sJacketPath );
				  self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end;
			elseif Course then
				-- We have a background (for jackets) 
				if ( Course:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Course:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- We have a banner
				elseif ( Course:GetBannerPath() ~= nil ) then
					self:Load( Course:GetBannerPath() );
					self:playcommand("Banner");
				-- Get your defaults
				else
					self:Load( sJacketPath );
					self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end
			-- What the hell did you do?! 
			else
				self:Load( bAllowJackets and sJacketPath or sBannerPath );
				self:playcommand( bAllowJackets and "Jacket" or "Banner" );
			end;
		end;
	};
	
	LoadActor(THEME:GetPathG("_song", "overlay")) .. {
		InitCommand=cmd(scaletoclipped,162,162);
	};
	
	-- Reflection
	
	Def.Sprite {
		Name="Banner";
		InitCommand=cmd(scaletoclipped,160,160;);
		-- Commands to make sure each banenr gets the right look.
		BannerCommand=cmd(scaletoclipped,160,160;y,80;vertalign,bottom;rotationz,-180;rotationy,-180;diffusealpha,0.5;croptop,0.5;fadetop,1);
		JacketCommand=cmd(scaletoclipped,160,160;y,80;vertalign,bottom;rotationz,-180;rotationy,-180;diffusealpha,0.5;croptop,0.5;fadetop,1);
		-- Set em up the graphics.
		SetMessageCommand=function(self,params)
			local Song = params.Song;
			local Course = params.Course;
			-- We have a song, not course
			if Song then
				-- Have Jacket
				if ( Song:GetJacketPath() ~=  nil ) and ( bAllowJackets ) then
					self:Load( Song:GetJacketPath() );
					self:playcommand("Jacket");
				-- Use Background if we want Jackets
				elseif ( Song:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Song:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- Use Banner if we dont care 
				elseif ( Song:GetBannerPath() ~= nil ) then
					self:Load( Song:GetBannerPath() );
					self:playcommand("Banner");
				-- Use Default
				else
				  self:Load( bAllowJackets and sBannerPath or sJacketPath );
				  self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end;
			elseif Course then
				-- We have a background (for jackets) 
				if ( Course:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Course:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- We have a banner
				elseif ( Course:GetBannerPath() ~= nil ) then
					self:Load( Course:GetBannerPath() );
					self:playcommand("Banner");
				-- Get your defaults
				else
					self:Load( sJacketPath );
					self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end
			-- What the hell did you do?! 
			else
				self:Load( bAllowJackets and sJacketPath or sBannerPath );
				self:playcommand( bAllowJackets and "Jacket" or "Banner" );
			end;
		end;
	};
	
	LoadActor(THEME:GetPathG("_song", "overlay")) .. {
		InitCommand=cmd(y,80;vertalign,bottom;scaletoclipped,162,162;rotationz,-180;rotationy,-180;diffusealpha,0.5;croptop,0.5;fadetop,1);
	};
};

return t;
	
-- Cute overlay

	
	
